<?php 
include("../includes/config.php");
include("../includes/function.php");
include("../includes/session.php");

$session = new Session();
$database = new Database();

$adminUserId = $session->get('userAdminID');
$adminEventId = $session->get('cmsEventId');
$getUserDetails = $database->getRecord("manage_users", "num='".$adminUserId."'");
$getEventDetails = $database->getRecord("manage_events", "num='".$adminEventId."'");
$documents = $database->getRecords("manage_speaker_videos", "1", "created_on ASC");
$speakerList = $database->getRecords("manage_speakers", "event_id='".$adminEventId."'", "created_on ASC");

include("includes/header.php");
?>
    <body class="top-navbar-fixed">
        <div class="main-wrapper">

            <?php echo include("includes/menu.php");?>

            <!-- ========== WRAPPER FOR BOTH SIDEBARS & MAIN CONTENT ========== -->
            <div class="content-wrapper">
                <div class="content-container">
                    <?php include("includes/sidebar.php");?>

                    <div class="main-page">
                        <div class="container-fluid">
                            <div class="row page-title-div">
                                <div class="col-md-6">
                                    <h4 class="title"><?php echo $getEventDetails['event_name'];?> - Speaker Videos</h4>
                                    <p class="sub-title">One stop solution for perfect admin dashboard!</p>
                                </div>
                                
                                <div class="col-md-6" style="text-align:right;">
                                    <ul class="nav navbar-nav navbar-right" data-dropdown-in="fadeIn" data-dropdown-out="fadeOut">
                                        <li>
                                    <a href="javascript:void(0);" class="dropdown-toggle bg-primary" data-toggle="modal" data-target="#modal2"><i class="fa fa-plus-circle"></i> Add New</a>
                                    </li>
                                    </div>
                                
                            </div>
                            <!-- /.row -->
                            <div class="row breadcrumb-div">
                                <div class="col-md-6">
                                    <ul class="breadcrumb">
            							<li><a href="<?php echo CMS_ROOT;?>dashboard.php"><i class="fa fa-home"></i> Home</a></li>
            							<li class="active">Speaker Videos</li>
            						</ul>
                                </div>
                                
                            </div>
                            <!-- /.row -->
                        </div>
                        <!-- /.container-fluid -->

                        <section class="section pt-10">
                            <div class="container-fluid">
                                <div class="row">
                                    <div class="col-md-12">
                                        
                                    <table id="example" class="display table table-striped table-bordered" cellspacing="0" width="100%">
                                                    <thead>
                                                        <tr>
                                                            <th width="200">Name</th>
                                                            <th width="200">Speaker</th>
                                                            <th width="200">Type</th>
                                                            <th width="100">Created On</th>
                                                            <th width="100">Action</th>
                                                        </tr>
                                                    </thead>
                                                    <tbody>
                                                        <?php foreach($documents as $record):
                                                        $exhibitors = $database->getRecord("manage_company_profile", "num='".$record['company_id']."'");
                                                        $speaker = $database->getRecord("manage_speakers", "num='".$record['speaker_id']."' AND event_id='".$adminEventId."'");
                                                        if($record['type']=="1") {
                                                            $type= "On Demand";
                                                        } else {
                                                            $type= "Webinar";
                                                        }
                                                        
                                                        if($speaker['num']==$record['speaker_id']){
                                                        ?>
                                                        <tr>
                                                            <td><?php echo $record['title'];?></td>
                                                            <td><?php echo $speaker['name'];?></td>
                                                            <td><?php echo $type;?></td>
                                                            <td><?php echo date("d-m-Y", strtotime($record['created_on']));?></td>
                                                            <td><button type="button" class="btn btn-success icon-only edit-record" data-title="<?php echo $record['title'];?>" data-description="<?php echo $record['description'];?>" data-speaker="<?php echo $record['speaker_id'];?>" data-type="<?php echo $record['type'];?>" data-image="<?php echo $record['web_image'];?>" data-url="<?php echo $record['video_url'];?>" data-date="<?php echo $record['web_date'];?>" data-start="<?php echo $record['start_time'];?>" data-end="<?php echo $record['end_time'];?>" data-id="<?php echo $record['num'];?>" data-toggle="modal" data-target="#modal2"><i class="fa fa-pencil"></i></button> <button type="button" data-id="delete-<?php echo $record['num'];?>" class="btn btn-danger del_url icon-only"><i class="fa fa-trash-o"></i></button></td>
                                                        </tr>
                                                        <?php } endforeach;?>
                                                    </tbody>
                                                </table>
                                                </div>
                                </div>
                                <!-- /.row -->
                            </div>
                            <!-- /.container-fluid -->
                        </section>
                        <!-- /.section -->

                        
                    </div>
                    <!-- /.main-page -->

                </div>
                <!-- /.content-container -->
            </div>
            <!-- /.content-wrapper -->

        </div>
        <!-- /.main-wrapper -->
        
        <!-- Modal -->
        <div class="modal fade draggable" id="modal2" tabindex="-1" role="dialog" aria-labelledby="modal2Label">
            <div class="modal-dialog" role="document">
                <div class="modal-content">
                    <form name="add_update_record" id="add_update_record" action=""  method="post">
                    <div class="modal-header draggable-handle">
                        <h4 class="modal-title" id="modal2Label"><i class="fa fa-arrows"></i> Add Speaker <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">×</span></button></h4>
                    </div>
                    <div class="modal-body">
                        
                            <input type="hidden" name="action" value="updateSpeakersVideo">
                            <input type="hidden" name="tablename" id="tablename" value="manage_speaker_videos">
                            <input type="hidden" name="record_id" id="record_id" value="">
                            <input type="hidden" name="user_id" id="user_id" value="<?php echo $session->get('userAdminID');?>">
                            <div class="col-md-6">
                                <div class="form-group">
                            		<label for="inputVideoTitle">Name</label>
                            		<input type="text" class="form-control" id="sTitle" name="sTitle" placeholder="Name">
                            	</div>
                            	<div class="form-group">
                            		<label for="inputVideoTitle">Speaker</label>
                            		<select class="form-control select2-hidden-accessible" name="speaker" id="speaker">
                            		    <option value="0">Please Select</option>
                            		    <?php foreach($speakerList as $record):?>
                            		        <option value="<?php echo $record['num'];?>"><?php echo $record['name'];?></option>
                            		    <?php endforeach;?>
                            		</select>
                            	</div>
                            	<div class="form-group">
                            		<label for="inputVideoTitle">Type</label>
                            		<select class="form-control select2-hidden-accessible" name="type" id="type">
                            		    <option value="0">Please Select</option>
                            		    <option value="2">Webinar</option>
                            		    <option value="1">On Demand</option>
                            		</select>
                            	</div>
                            	<div id="hideDiv">
                            	<div class="form-group">
                            		<label for="inputVideoTitle">Date</label>
                            		<input type="date" class="form-control" id="web_date" name="web_date">
                            	</div>
                            	<div class="form-group">
                            		<label for="inputVideoTitle">Time</label>
                            		Start :<input type="time" class="form-control" id="start_time" name="start_time"> End :<input type="time" class="form-control" id="end_time" name="end_time">
                            	</div>
                            	</div>
                            </div>
                            <div class="col-md-6">
                            	<div class="form-group">
                            		<label for="inputVideoTitle">Description</label>
                            		<textarea class="form-control" name="description" id="description" placeholder="Default Textarea" rows="5"></textarea>
                            	</div>
                            	<div class="form-group">
                            		<label for="inputVideoUrl">Image</label>
                            		<input type="file" class="form-control" id="image_url" name="image_url" placeholder="Image"><br><br>
                            		<img src="" id="docurl" style="width:200px;">
                            	</div>
                            	<div class="form-group">
                            		<label for="inputVideoTitle">Video Url</label>
                            		<input type="text" class="form-control" id="vUrl" name="vUrl" placeholder="Video Url">
                            	</div>
                            </div>
                            <br clear="all">
                    </div>
                    <div class="modal-footer">
                        <div class="btn-group" role="group">
                            <button type="button" class="btn btn-gray btn-wide btn-rounded" id="close_popup" data-dismiss="modal"><i class="fa fa-times"></i>Close</button>
                            <button type="submit" class="btn bg-success btn-wide btn-rounded"><i class="fa fa-check"></i>Save</button>
                        </div>
                        <!-- /.btn-group -->
                    </div>
                    </form>
                </div>
            </div>
        </div>

        <!-- ========== COMMON JS FILES ========== -->
        <script src="<?php echo CMS_ROOT;?>js/jquery/jquery-2.2.4.min.js"></script>
        <script src="<?php echo CMS_ROOT;?>js/bootstrap/bootstrap.min.js"></script>
        <script src="<?php echo CMS_ROOT;?>js/pace/pace.min.js"></script>
        <script src="<?php echo CMS_ROOT;?>js/lobipanel/lobipanel.min.js"></script>
        <script src="<?php echo CMS_ROOT;?>js/iscroll/iscroll.js"></script>

        <!-- ========== PAGE JS FILES ========== -->
        <script src="<?php echo CMS_ROOT;?>js/prism/prism.js"></script>
        <script src="<?php echo CMS_ROOT;?>js/iziModal/iziModal.min.js"></script>
        <script src="<?php echo CMS_ROOT;?>js/sweet-alert/sweetalert.min.js"></script>

        <script src="<?php echo CMS_ROOT;?>js/DataTables/datatables.min.js"></script>

        <!-- ========== THEME JS ========== -->
        <script src="<?php echo CMS_ROOT;?>js/main.js"></script>
        <script>
        $(document).ready(function() {
                $("#modal12").iziModal();
                $('.modal-12-trigger').on('click', function(){
                    $('#modal12').iziModal('open', this);
                });
                
                $("#close_popup").click(function(){
                   location.reload(); 
                });
                
                $("#add_update_recorda").submit(function() {
                    var dataString = $(this).serialize();
                   $.ajax({
                    type: "POST",
                    url: "/includes/process.php",
                    async: true,
        			contentType: false,
            	    cache: false,
        			processData:false,
                    data: new FormData(this),
                    success: function(data){
                        if(data=="1") {
                            $(".modal-body").append("<div style='color:#fff; background:#5ECFB1; padding:5px;'>Data updated successfully</div>");
                        }
                    }
                  }); 
                  return false;
                });
                
                $(".close").click(function(){
                   location.reload(); 
                });
                
                $("#add_update_record").submit(function() {
                    var dataString = $(this).serialize();
                   $.ajax({
                    type: "POST",
                    url: "/includes/process.php",
                    async: true,
        			contentType: false,
            	    cache: false,
        			processData:false,
                    data: new FormData(this),
                    success: function(data){
                        console.log(data);
                        if(data=="v") {
                            $(".modal-body").append("<div style='color:#fff; background:#5ECFB1; padding:5px;'>Data updated successfully</div>");
                        }
                    }
                  }); 
                  return false;
                });
                
                $(".edit-record").click(function() {
                    var inputVideoId = $(this).attr("data-id");
                    var inputTitle = $(this).attr("data-title");
                    var inputSpeaker = $(this).attr("data-speaker");
                    var inputType = $(this).attr("data-type");
                    var inputDescription = $(this).attr("data-description");
                    var inputImage = $(this).attr("data-image");
                    var inputUrl = $(this).attr("data-url");
                    var inputDate = $(this).attr("data-date");
                    var inputStartTime = $(this).attr("data-start");
                    var inputEndTime = $(this).attr("data-end");
                    $("#record_id").val(inputVideoId);
                    $("#sTitle").val(inputTitle);
                    $("#speaker").val(inputSpeaker);
                    $("#type").val(inputType);
                    $("#web_date").val(inputDate);
                    $("#start_time").val(inputStartTime);
                    $("#end_time").val(inputEndTime);
                    $("#description").val(inputDescription);
                    $("#docurl").attr("src", inputImage);
                    $("#vUrl").val(inputUrl);
                });
                
                $("#type").change(function() {
                   var typeVal = $(this).val();
                   if(typeVal==1) {
                       $("#hideDiv").hide();
                   } else {
                       $("#hideDiv").show();
                   }
                });
                
                $(".del_url").on("click", function() {
                    var videoId = $(this).attr("data-id");
                    var dataString = "recordId="+videoId+"&tablename=manage_speaker_videos&action=ajaxRecord";
                    $.ajax({
                        type: "POST",
                        url: "/includes/process.php",
                        data: dataString,
                        success: function(data){
                            location.reload();
                            $(this).parent().parent().hide();
                        }
                      }); 
                });
                
                $('#example').DataTable();
                $( ".draggable" ).draggable({ handle: ".draggable-handle" });
        });
        </script>

        <!-- ========== ADD custom.js FILE BELOW WITH YOUR CHANGES ========== -->
    </body>
</html>
