<?php
session_start();
session_destroy();
include("../includes/config.php");
include("../includes/function.php");
include("../includes/session.php");

$session = new Session();
$database = new Database();?>
<!DOCTYPE html>
<html lang="en">
    <head>
        <meta charset="utf-8">
        <meta http-equiv="X-UA-Compatible" content="IE=edge">
    	<meta name="viewport" content="width=device-width, initial-scale=1">
        <title>Abstract Management - Login</title>

        <!-- ========== COMMON STYLES ========== -->
        <link rel="stylesheet" href="<?php echo CMS_ROOT;?>css/bootstrap.min.css" media="screen" >
        <link rel="stylesheet" href="<?php echo CMS_ROOT;?>css/font-awesome.min.css" media="screen" >
        <link rel="stylesheet" href="<?php echo CMS_ROOT;?>css/animate-css/animate.min.css" media="screen" >

        <!-- ========== PAGE STYLES ========== -->
        <link rel="stylesheet" href="<?php echo CMS_ROOT;?>css/icheck/skins/flat/blue.css" >

        <!-- ========== THEME CSS ========== -->
        <link rel="stylesheet" href="<?php echo CMS_ROOT;?>css/main.css" media="screen" >

        <!-- ========== MODERNIZR ========== -->
        <script src="<?php echo CMS_ROOT;?>js/modernizr/modernizr.min.js"></script>
    </head>
    <body class="">
        <div class="main-wrapper">

            <div class="login-bg-color bg-black-300">
                <div class="row">
                    <div class="col-md-4 col-md-offset-4">
                        <div class="panel login-box">
                            <?php if($_REQUEST['forgot']=="1") {?>
                            <div class="panel-heading">
                                <div class="panel-title text-center">
                                    <h4>Forgot Password</h4>
                                </div>
                            </div>
                            <div class="panel-body p-20">

                                <div class="section-title">
                                    <p class="sub-title text-muted">Should you experience any issue with your login attempts please contact our support team - <a href="mailto:support@xibitrs.com">support@xibitrs.com</a></p>
                                </div>
                                
                                    <div class="fsuccess" style="background:#5ECFB1 !important; padding:5px; color:#fff; display:none; text-align:left; border-radius:5px; margin-bottom:10px;"></div>
                                    <div class="ferror" style="background:red !important; padding:5px; color:#fff; display:none; text-align:left; border-radius:5px; margin-bottom:10px;"></div>
                                    <form method="post" id="registerforma" name="registerforma">
                                        <input type="hidden" name="tablename" id="tablename" value="manage_users">
                                                <input type="hidden" id="action" name="action" value="cmsloginform">
                                    	<div class="form-group">
                                    		<label for="exampleInputEmail1">Email address</label>
                                            <input type="email" name="email" required class="form-control" id="exampleInputEmail1" placeholder="Enter Your Email Id" autocomplete="off" >
                                    	</div>
                                    	<div class="form-group mt-20">
                                            <div class="">
                                                <a href="<?php echo CMS_ROOT;?>login.php" class="form-link"><small class="muted-text">Back to login</small></a>
                                                <button type="submit" class="btn btn-success btn-labeled forgotEmailBtn pull-right">Submit<span class="btn-label btn-label-right"><i class="fa fa-check"></i></span></button>
                                                <div class="clearfix"></div>
                                            </div>
                                        </div>
                                    </form>

                            </div>
                            <?php } else {?>
                            <div class="panel-heading">
                                <div class="panel-title text-center">
                                    <h4>Abstract Management</h4>
                                </div>
                            </div>
                            <div class="panel-body p-20">

                                <div class="section-title">
                                    <p class="sub-title text-muted">Should you experience any issue with your login attempts please contact our support team - <a href="mailto:support@xibitrs.com">support@xibitrs.com</a></p>
                                </div>
                                
                                <div class="error" style="background:red !important; padding:5px; color:#fff; text-align:left; display:none; border-radius:5px; margin-bottom:10px;">Your email or password is incorrect. Please check and try again.</div>

                                    
                                    <form method="post" id="registerform" name="registerform">
                                    <input type="hidden" name="tablename" id="tablename" value="manage_users">
                                            <input type="hidden" id="action" name="action" value="cmsloginform">
                                	<div class="form-group">
                                		<label for="exampleInputEmail1">Email address</label>
                                        <input type="email" name="email" required class="form-control" id="exampleInputEmail1" placeholder="Enter Your Email Id" autocomplete="off" >
                                	</div>
                                	<div class="form-group">
                                		<label for="exampleInputPassword1">Password</label>
                                		<input type="password" required name="password" class="form-control" id="exampleInputPassword1" placeholder="Password">
                                	</div>
                                    <div class="checkbox op-check">
                                        <label>
                                            <input type="checkbox" name="remember" class="flat-blue-style"> <span class="ml-10">Remember me</span>
                                        </label>
                                    </div>
                                    <div class="form-group mt-20">
                                        <div class="">
                                            <a href="<?php echo CMS_ROOT;?>login.php?forgot=1" class="form-link"><small class="muted-text">Forgot Password?</small></a>
                                            <button type="submit" class="btn btn-success btn-labeled pull-right">Sign in<span class="btn-label btn-label-right"><i class="fa fa-check"></i></span></button>
                                            <div class="clearfix"></div>
                                        </div>
                                    </div>
                                </form>

                            </div>
                            <?php } ?>
                        </div>
                        <!-- /.panel -->
                        <p class="text-muted text-center"><small>Copyright © Xibitrs Limited 2020</small></p>
                    </div>
                    <!-- /.col-md-6 col-md-offset-3 -->
                </div>
                <!-- /.row -->
            </div>
            <!-- /. -->

        </div>
        <!-- /.main-wrapper -->

        <!-- ========== COMMON JS FILES ========== -->
        <script src="<?php echo CMS_ROOT;?>js/jquery/jquery-2.2.4.min.js"></script>
        <script src="<?php echo CMS_ROOT;?>js/jquery-ui/jquery-ui.min.js"></script>
        <script src="<?php echo CMS_ROOT;?>js/bootstrap/bootstrap.min.js"></script>
        <script src="<?php echo CMS_ROOT;?>js/pace/pace.min.js"></script>
        <script src="<?php echo CMS_ROOT;?>js/lobipanel/lobipanel.min.js"></script>
        <script src="<?php echo CMS_ROOT;?>js/iscroll/iscroll.js"></script>

        <!-- ========== PAGE JS FILES ========== -->
        <script src="<?php echo CMS_ROOT;?>js/icheck/icheck.min.js"></script>

        <!-- ========== THEME JS ========== -->
        <script src="<?php echo CMS_ROOT;?>js/main.js"></script>
        <script>
            $(function(){
                $('input.flat-blue-style').iCheck({
                    checkboxClass: 'icheckbox_flat-blue'
                });
            });
        </script>

        <!-- ========== ADD custom.js FILE BELOW WITH YOUR CHANGES ========== -->
        <script type="text/javascript">
            $(document).ready(function() {
                $("#registerform").submit(function() {
                    var username = $("#exampleInputEmail1").val();
                    var password = $("#exampleInputPassword1").val();
                    var action = $("#action").val();
                    var tablename = $("#tablename").val();
                    var dataString = "username="+username+"&password="+password+"&action="+action+"&tablename="+tablename;
                   $.ajax({
                    type: "POST",
                    url: "/includes/process.php",
                    data: dataString,
                    success: function(data){
                     if(data=="Password Verified!") {
                         $(location).attr('href', 'https://platform.xibitrs.net/cms/dashboard.php');
                     } else {
                         $(".error").show();
                     }
                    }
                  }); 
                  return false;
                });
                
                $("#registerforma").submit(function() {
                  var dataString = "forgotemail="+$("#exampleInputEmail1").val()+"&action=forgotemail";
                  $.ajax({
                    type: "POST",
                    url: "/includes/process.php",
                    data: dataString,
                    success: function(data){
                        if(data=="Email has been sent") {
                            $(".fsuccess").show();
                            $(".fsuccess").html(data);
                            $(".ferror").hide();
                        } else {
                            $(".fsuccess").hide();
                            $(".ferror").show();
                            $(".ferror").html(data);
                        }
                     
                    }
                  }); 
                  return false;
              });
            });
        </script>
    </body>
</html>
