<?php 
include("../includes/config.php");
include("../includes/function.php");
include("../includes/session.php");

$session = new Session();
$database = new Database();

$documents = $database->getRecords("manage_lobby_images", "1", "created_on ASC");

include("includes/header.php");
?>
    <body class="top-navbar-fixed">
        <div class="main-wrapper">

            <?php echo include("includes/menu.php");?>

            <!-- ========== WRAPPER FOR BOTH SIDEBARS & MAIN CONTENT ========== -->
            <div class="content-wrapper">
                <div class="content-container">
                    <?php include("includes/sidebar.php");?>

                    <div class="main-page">
                        <div class="container-fluid">
                            <div class="row page-title-div">
                                <div class="col-md-6">
                                    <h4 class="title">Lobby Images</h4>
                                    <p class="sub-title">One stop solution for perfect admin dashboard!</p>
                                </div>
                                
                                <div class="col-md-6" style="text-align:right;">
                                    <ul class="nav navbar-nav navbar-right" data-dropdown-in="fadeIn" data-dropdown-out="fadeOut">
                                        <li>
                                    <a href="javascript:void(0);" class="dropdown-toggle bg-primary" data-toggle="modal" data-target="#modal2"><i class="fa fa-plus-circle"></i> Add New</a>
                                    </li>
                                    </div>
                                
                            </div>
                            <!-- /.row -->
                            <div class="row breadcrumb-div">
                                <div class="col-md-6">
                                    <ul class="breadcrumb">
            							<li><a href="<?php echo CMS_ROOT;?>dashboard.php"><i class="fa fa-home"></i> Home</a></li>
            							<li class="active">Lobby</li>
            						</ul>
                                </div>
                                
                            </div>
                            <!-- /.row -->
                        </div>
                        <!-- /.container-fluid -->

                        <section class="section pt-10">
                            <div class="container-fluid">
                                <div class="row">
                                    <div class="col-md-12">
                                        
                                    <table id="example" class="display table table-striped table-bordered" cellspacing="0" width="100%">
                                                    <thead>
                                                        <tr>
                                                            <th width="300">Name</th>
                                                            <th width="400">Image</th>
                                                            <th width="200">Created On</th>
                                                            <th width="100">Action</th>
                                                        </tr>
                                                    </thead>
                                                    <tbody>
                                                        <?php foreach($documents as $record):
                                                        $exhibitors = $database->getRecord("manage_company_profile", "num='".$record['company_id']."'");?>
                                                        <tr>
                                                            <td><?php echo $record['title'];?></td>
                                                            <td><a href="<?php echo $record['url'];?>" target="_blank"><img src="<?php echo $record['url'];?>" style="width:200px;"></a></td>
                                                            <td><?php echo date("d-m-Y", strtotime($record['created_on']));?></td>
                                                            <td><button type="button" class="btn btn-success icon-only edit-record" data-title="<?php echo $record['title'];?>" data-url="<?php echo $record['url'];?>" data-id="<?php echo $record['num'];?>" data-toggle="modal" data-target="#modal2"><i class="fa fa-pencil"></i></button> <button type="button" data-id="delete-<?php echo $record['num'];?>" class="btn btn-danger del_url icon-only"><i class="fa fa-trash-o"></i></button></td>
                                                        </tr>
                                                        <?php endforeach;?>
                                                    </tbody>
                                                </table>
                                                </div>
                                </div>
                                <!-- /.row -->
                            </div>
                            <!-- /.container-fluid -->
                        </section>
                        <!-- /.section -->

                        
                    </div>
                    <!-- /.main-page -->

                </div>
                <!-- /.content-container -->
            </div>
            <!-- /.content-wrapper -->

        </div>
        <!-- /.main-wrapper -->
        
        <!-- Modal -->
        <div class="modal fade draggable" id="modal2" tabindex="-1" role="dialog" aria-labelledby="modal2Label">
            <div class="modal-dialog" role="document">
                <div class="modal-content">
                    <form name="add_update_record" id="add_update_record" action=""  method="post">
                    <div class="modal-header draggable-handle">
                        <h4 class="modal-title" id="modal2Label"><i class="fa fa-arrows"></i> Add Lobby <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">×</span></button></h4>
                    </div>
                    <div class="modal-body">
                        
                            <input type="hidden" name="action" value="uploadCmsDoc">
                            <input type="hidden" name="tablename" id="tablename" value="manage_lobby_images">
                            <input type="hidden" name="foldername" id="foldername" value="lobby">
                            <input type="hidden" name="doc_record_id" id="doc_record_id" value="">
                            <input type="hidden" name="user_id" id="user_id" value="<?php echo $session->get('userAdminID');?>">
                            <div class="form-group">
                        		<label for="inputVideoTitle">Title</label>
                        		<input type="text" class="form-control" id="dTitle" name="dTitle" placeholder="Video Title">
                        	</div>
                        	<div class="form-group">
                        		<label for="inputVideoUrl">Url</label>
                        		<input type="file" class="form-control" id="asset_doc" name="asset_doc" placeholder="Video Url"><br><br>
                        		<img src="" id="docurl" style="width:200px;">
                        	</div>
                    </div>
                    <div class="modal-footer">
                        <div class="btn-group" role="group">
                            <button type="button" class="btn btn-gray btn-wide btn-rounded" id="close_popup" data-dismiss="modal"><i class="fa fa-times"></i>Close</button>
                            <button type="submit" class="btn bg-success btn-wide btn-rounded"><i class="fa fa-check"></i>Save</button>
                        </div>
                        <!-- /.btn-group -->
                    </div>
                    </form>
                </div>
            </div>
        </div>

        <!-- ========== COMMON JS FILES ========== -->
        <script src="<?php echo CMS_ROOT;?>js/jquery/jquery-2.2.4.min.js"></script>
        <script src="<?php echo CMS_ROOT;?>js/bootstrap/bootstrap.min.js"></script>
        <script src="<?php echo CMS_ROOT;?>js/pace/pace.min.js"></script>
        <script src="<?php echo CMS_ROOT;?>js/lobipanel/lobipanel.min.js"></script>
        <script src="<?php echo CMS_ROOT;?>js/iscroll/iscroll.js"></script>

        <!-- ========== PAGE JS FILES ========== -->
        <script src="<?php echo CMS_ROOT;?>js/prism/prism.js"></script>
        <script src="<?php echo CMS_ROOT;?>js/iziModal/iziModal.min.js"></script>
        <script src="<?php echo CMS_ROOT;?>js/sweet-alert/sweetalert.min.js"></script>

        <script src="<?php echo CMS_ROOT;?>js/DataTables/datatables.min.js"></script>

        <!-- ========== THEME JS ========== -->
        <script src="<?php echo CMS_ROOT;?>js/main.js"></script>
        <script>
        $(document).ready(function() {
                $("#modal12").iziModal();
                $('.modal-12-trigger').on('click', function(){
                    $('#modal12').iziModal('open', this);
                });
                
                $("#close_popup").click(function(){
                   location.reload(); 
                });
                
                $("#add_update_recorda").submit(function() {
                    var dataString = $(this).serialize();
                   $.ajax({
                    type: "POST",
                    url: "/includes/process.php",
                    async: true,
        			contentType: false,
            	    cache: false,
        			processData:false,
                    data: new FormData(this),
                    success: function(data){
                        if(data=="1") {
                            $(".modal-body").append("<div style='color:#fff; background:#5ECFB1; padding:5px;'>Data updated successfully</div>");
                        }
                    }
                  }); 
                  return false;
                });
                
                $(".close").click(function(){
                   location.reload(); 
                });
                
                $("#add_update_record").submit(function() {
                    var dataString = $(this).serialize();
                   $.ajax({
                    type: "POST",
                    url: "/includes/process.php",
                    async: true,
        			contentType: false,
            	    cache: false,
        			processData:false,
                    data: new FormData(this),
                    success: function(data){
                        if(data=="v") {
                            $(".modal-body").append("<div style='color:#fff; background:#5ECFB1; padding:5px;'>Data updated successfully</div>");
                        }
                    }
                  }); 
                  return false;
                });
                
                $(".edit-record").click(function() {
                    var inputVideoId = $(this).attr("data-id");
                    var inputVideoTitle = $(this).attr("data-title");
                    var inputVideoUrl = $(this).attr("data-url");
                    $("#doc_record_id").val(inputVideoId);
                    $("#dTitle").val(inputVideoTitle);
                    $("#inputVideoUrl").val(inputVideoUrl);
                    $("#docurl").attr("src", inputVideoUrl);
                });
                
                $(".del_url").on("click", function() {
                    var videoId = $(this).attr("data-id");
                    var dataString = "recordId="+videoId+"&tablename=manage_lobby_images&action=ajaxRecord";
                    if (confirm("OK to submit?")) {
                        $.ajax({
                            type: "POST",
                            url: "/includes/process.php",
                            data: dataString,
                            success: function(data){
                                location.reload();
                                $(this).parent().parent().hide();
                            }
                          }); 
                    }
                });
                
                $('#example').DataTable();
                $( ".draggable" ).draggable({ handle: ".draggable-handle" });
        });
        </script>

        <!-- ========== ADD custom.js FILE BELOW WITH YOUR CHANGES ========== -->
    </body>
</html>
